/*
   This is similar to Ex2_WatchBuffering.java.

   Bytes are sent from the parent to the child
   and we get to see how flushing the parent's
   output buffer causes the child to see what
   was sent to it.
*/
import java.util.Scanner;
import java.io.*;

public class Ex3_WatchBuffering
{
   public static void main(String[] args) throws IOException, InterruptedException
   {
      // Command line for running the child process.
      String[] cmd = {"java", "Ex3_WatchBuffering_Child"};
      // Execute the command line.
      final Process process = Runtime.getRuntime().exec(cmd);
      // Give this parent the ability to shut down the child.
      Runtime.getRuntime().addShutdownHook(new Thread(){public void run(){process.destroy();}});


      // A stream that writes data to the child's stdin stream (the "pipe").
      PrintStream stdinOfChild =  new PrintStream( process.getOutputStream() );

      // A stream that reads data from the child's stdout stream.
      final Scanner stdoutOfChild = new Scanner( process.getInputStream() );

      // Create a "pump" between the child's output stream and stdout.
      new Thread(new Runnable(){public void run()
      {while(stdoutOfChild.hasNextLine())
       {String oneLine = stdoutOfChild.nextLine(); // read from output of child
        System.out.println( oneLine );             // write to standard out
       }}}).start();

      // Write 5 bytes to the child's input buffer.
      stdinOfChild.print("a"); System.out.println("a");
      stdinOfChild.print("a"); System.out.println("a");
      stdinOfChild.print("a"); System.out.println("a");
      stdinOfChild.print("a"); System.out.println("a");
      stdinOfChild.print("a"); System.out.println("a");

      Thread.sleep(5000);

      System.out.println("flush");
      stdinOfChild.flush(); // Child doesn't see any input until this output stream is flushed

      Thread.sleep(6000);  // wait for the child's output

      stdinOfChild.print("aaaaa"); System.out.println("aaaaa");

      Thread.sleep(5000);

      System.out.println("flush");
      stdinOfChild.flush(); // Child doesn't see any input until this output stream is flushed

      Thread.sleep(6000);  // wait for the child's output

      final int COUNT = 8192; // Try making this 8193. Also try 16384 and 16385.
      System.out.println("Send " + COUNT + " bytes to child.");
      for (int i = 0; i < COUNT; i++) // 8192 comes form Ex2_WatchBuffering.java
      {
         stdinOfChild.print("a");
      }
      System.out.println("Done");

      Thread.sleep(5000);

      System.out.println("flush");
      stdinOfChild.flush();   // This flush isn't always needed! Not sure why.

      //stdinOfChild.close();

      process.waitFor();  // throws InterruptedException
   }
}

/*
   NOTE: The number 8192 seems to be the size of the
   parent output bufer plus the size of the pipe buffer.
   When the program first strats up, the parent will
   block if it send more than 8192 bytes to the child
   (assuming the child is sleeping). But once the pipe
   is in use, it seems that writing 8182 bytes into an
   empty output and pipe buffer triggers autoflush?
*/